@extends('layouts.setup')
@section('content')
<div class="d-flex justify-content-center">
	<div class="card mt-4 text-dark wizard-form border-0 shadow-custom text-sm">
		<div class="card-header border-grey">
			<h3 class="card-title float-none text-center">
				Database Configurations
			</h3>
		</div>
		
		<div class="card-body">
			<div class="col-md-12">
				@if (\Session::has('error'))
					<div class="alert alert-danger mb-3 text-center">
						<p class="mb-0">{{ \Session::get('error') }}</p>
					</div>
				@endif

				@if (\Session::has('success'))
					<div class="alert alert-success mb-3 text-center">
						<p class="mb-0">{{ \Session::get('success') }}</p>
					</div>
				@endif
			</div>
			@if($status == 'create') 
			<div class="col-md-12">
				<form action="{{ route('setup.setup_database') }}" method="post" autocomplete="off">
					{{ csrf_field() }}
					
						<div class="form-group">
							<label for="name" class="required">Hostname</label>
							<input type="text" value="{{ old('hostname') }}" class="form-control @error('hostname') is-invalid @enderror" name="hostname" id="hostname">
							@error('hostname')
								<span class="d-block invalid-feedback">{{ $message }}</span>
							@enderror
						</div>

						<div class="form-group">
							<label for="name" class="required">Database</label>
							<input type="text" value="{{ old('database') }}" class="form-control @error('database') is-invalid @enderror" name="database" id="database">
							@error('database')
								<span class="d-block invalid-feedback">{{ $message }}</span>
							@enderror
						</div>

						<div class="form-group">
							<label for="name" class="required">Username</label>
							<input type="text" value="{{ old('username') }}" class="form-control @error('username') is-invalid @enderror" name="username" id="username">
							@error('username')
								<span class="d-block invalid-feedback">{{ $message }}</span>
							@enderror
						</div>
		
						<div class="form-group">
							<label for="name" class="required">Password</label>
							<input type="password" value="{{ old('password') }}" class="form-control @error('password') is-invalid @enderror" name="password" id="password">
							@error('password')
								<span class="d-block invalid-feedback">{{ $message }}</span>
							@enderror
						</div>
						<button type="submit" class="btn btn-primary">Submit</button>
				</form>
			</div>
			@else
				<div class="col-md-12 d-flex justify-content-center">
					<a href="{{ route('setup.user') }}" class="btn btn-primary">Next</a>
				</div>
			@endif
		</div>
	</div>
</div>
@endsection
